--Created by Jeff Handke - MA-Share.net User: JSHDesigns
--V1.0 - Initial Release 05/18/2021


--PLUGIN VARIABLES--
local prop = gma.show.property
local obj = gma.show.getobj
local progress = gma.gui.progress
local msg = gma.gui.msgbox
local fb = gma.feedback
local echo = gma.echo
ftno = {}
virtualcountft = {}
virtualcount = {}
extcountft = {}
extcount = {}
totalcountft = {}
totalcount = {}
modname = {}


function virtual()
--Get Fixturetype Info--
  ft = obj.handle('Root LiveSetup.FixtureTypes')
  amounta = obj.amount(ft)
  pbara = progress.start("FixtureType")
  progress.setrange(pbara,0,amounta)
  for a=2,amounta do
    progress.set(pbara,a)
    ft2 = obj.handle('Root LiveSetup.FixtureTypes.'..a)
    ftno[a-1] = prop.get(ft2, 'No.')
    insttable = {}
--Get Instances of Fixturetypes--
    instance = obj.handle('Root LiveSetup.Fixturetypes.'..a..'.Instances')
    amountb = obj.amount(instance)
    pbarb = progress.start("Instance")
    progress.setrange(pbarb,0,amountb);
    for b=1,amountb do
      progress.set(pbarb,b)
      instance = obj.handle('Root LiveSetup.Fixturetypes.'..a..'.Instances.'..b)
      instancename = prop.get(instance, 'ModuleType')
      insttable[b] = instancename
      if b == amountb then
        progress.stop(pbarb)
      end
    end
--Get Modules of Fixturetypes
    module = obj.handle('Root LiveSetup.Fixturetypes.'..a..'.Modules')
    amountc = obj.amount(module)
    pbarc = progress.start("Module")
    progress.setrange(pbarc,0,amountc)
    for c=1,amountc do
      progress.set(pbarc,c)
      module = obj.handle('Root LiveSetup.Fixturetypes.'..a..'.Modules.'..c)
      amountd = obj.amount(module)
      modname[c] = prop.get(module, 'Name')
      pbard = progress.start("Attribute")
      progress.setrange(pbard,0,amountd)
      virtual = 0
      extended = 0
      total = 0
--Get Attributes of Modules
      for d=1,amountd do
        progress.set(pbard,d)
        module = obj.handle('Root LiveSetup.Fixturetypes.'..a..'.Modules.'..c..'.'..d)
        coarse = prop.get(module, 'Coarse')
        fine = prop.get(module, 'Fine')
        ultra = prop.get(module, 'Ultra')
        attrib = prop.get(module, 'Attrib')
        if coarse == '' then
          virtual = (virtual + 1)
        else
          if attrib ~= 'None' then 
            total = (total + 1)
          end
        end
        if fine ~= '' then
          extended = (extended + 1)
        end
        if ultra ~= '' then
          extended = (extended + 1)
        end
        if d == amountd then
          progress.stop(pbard)
        end
      end
      extcountft[c] = extended
      virtualcountft[c] = virtual
      totalcountft[c] = total 
      if c == amountc then
        progress.stop(pbarc)
      end
    end
--Calculate Number of Instances per Module
    virtual = 0
    extended = 0
    total = 0
    for key, value in pairs(insttable) do
      for key2, value2 in pairs(modname) do
        if value == value2 then
          total = (total + totalcountft[key2] + virtualcountft[key2])
          virtual = (virtual + virtualcountft[key2])
          extended = (extended + extcountft[key2])
          break
        end
      end
      extcount[a] = extended
      virtualcount[a] = virtual
      totalcount[a] = total
      if a == amounta then
        progress.stop(pbara)
      end
    end
  end
--Get Patch Information--
  newtotal = 0
  newvirtual = 0
  newext = 0
  patchlayers = obj.handle('Root LiveSetup.Layers')
  amounte = obj.amount(patchlayers)
  pbare = progress.start("PatchLayer")
  progress.setrange(pbare,0,amounte)
  for e=2,amounte do
    progress.set(pbare,e)
    patchfixt = obj.handle('Root LiveSetup.Layers.'..e)
    amountf = obj.amount(patchfixt)
    pbarf = progress.start("Fixture")
    progress.setrange(pbarf,0,amountf) 
    for f=1,amountf do
      progress.set(pbarf,f)
      fixt = obj.handle('Root LiveSetup.Layers.'..e..'.'..f)
      patchtype = prop.get(fixt, 'FixtureType')
      patch = prop.get(fixt, 'Patch')
      for key,value in pairs(ftno) do
        parsed = string.match(patchtype, '%d+')
        if parsed == value then
          newtotal = newtotal + totalcount[key+1]
          newext = newext + extcount[key+1]
          if patch == ' (-)' then
            newvirtual = newvirtual + totalcount[key+1]
          else
            newvirtual = newvirtual + virtualcount[key+1] 
          end
          break
        end
      end
      if f == amountf then
        progress.stop(pbarf)
      end
      if e == amounte then
        progress.stop(pbare)
      end
    end
  end
  fb(string.char(27)..'[3'..'5m\nUsed Parameters: '..newtotal..'\nVirtual Parameters: '..newvirtual..'\nActual Used Parameters: '..(newtotal - newvirtual)..'\nExtended Parameters: '..newext)
  echo(string.char(27)..'[3'..'5m\nUsed Parameters: '..newtotal..'\nVirtual Parameters: '..newvirtual..'\nActual Used Parameters: '..(newtotal - newvirtual)..'\nExtended Parameters: '..newext)
  msg('Parameter Count','Used Parameters: '..newtotal..'\nVirtual Parameters: '..newvirtual..'\nActual Used Parameters: '..(newtotal - newvirtual)..'\nExtended Parameters: '..newext)
end

function cleanup()
  progress.stop(pbara)
  progress.stop(pbarb)
  progress.stop(pbarc)
  progress.stop(pbard)
  progress.stop(pbare)
  progress.stop(pbarf)
end

return virtual, cleanup;